from flask import Flask, request, abort

from linebot_events import handler
from linebot.exceptions import InvalidSignatureError

app = Flask(__name__)

@app.route("/callback_line", methods=["POST"])
def callback():
    print("Received a POST request")
    signature = request.headers["X-Line-Signature"]
    body = request.get_data(as_text=True)

    try:
        handler.handle(body, signature)
    except InvalidSignatureError:
        abort(400)
    return "OK"

if __name__ == "__main__":
    app.run(host='0.0.0.0', port=8082)
