import mysql.connector
from database import db_config
from linebot import LineBotApi, WebhookHandler
from linebot.exceptions import LineBotApiError, InvalidSignatureError
from linebot.models import (
    MessageEvent,
    TextMessage,
    TextSendMessage,
    JoinEvent,
    FollowEvent,
    FlexSendMessage,
    BubbleContainer,
    ImageComponent,
    BoxComponent,
    TextComponent,
)

from database import get_allowed_users_count

line_bot_api = LineBotApi("eFsVHWcys9II3rvtcOi0ly/AI1iJF2nnAQE2NpASOld1sUJkr9aYR0nYJV/U02eOjP8FGGcMJoiHkvCqcvUN+RQS4d4ZxGuITeZ4dSXZnJuWEceY+nWt2/b/LTEwlX3Q9IaQw4R/91etFspH4PuF2wdB04t89/1O/w1cDnyilFU=")
handler = WebhookHandler("654dc1edea42e619ebf21a9470eda8a4")

@handler.add(JoinEvent)
def handle_join_event(event):
    reply_token = event.reply_token
    welcome_message = "您好，歡迎使用觸發型解剖事件錄影模組！，請輸入「功能」來查看使用方法。"
    line_bot_api.reply_message(reply_token, TextSendMessage(text=welcome_message))

@handler.add(FollowEvent)
def handle_follow_event(event):
    reply_token = event.reply_token
    line_id = event.source.user_id

    cnx = mysql.connector.connect(**db_config)
    cursor = cnx.cursor()
    query = "SELECT COUNT(*) FROM allowed_users WHERE line_id = %s"
    cursor.execute(query, (line_id,))
    count = cursor.fetchone()[0]

    if count == 0:
        line_bot_api.block_user(line_id)
        return "OK"

    welcome_message = "您好，歡迎使用觸發型解剖事件錄影模組！，請輸入「功能」來查看使用方法。"
    line_bot_api.reply_message(reply_token, TextSendMessage(text=welcome_message))
    cursor.close()
    cnx.close()

# 管理員USER_ID
# admin_line_ids = [""]
admin_line_ids = ["Ucd92fde38c85d7ed25fa208a7b98c5b7"]

@handler.add(MessageEvent, message=TextMessage)
def handle_text_message(event):
    print(f"Received message: {event.message.text}")

    line_id = event.source.user_id

    cnx = mysql.connector.connect(**db_config)
    cursor = cnx.cursor()
    query = "SELECT COUNT(*) FROM allowed_users WHERE line_id = %s"
    cursor.execute(query, (line_id,))
    count = cursor.fetchone()[0]

    if count == 0:
        line_bot_api.reply_message(
            event.reply_token,
            TextSendMessage(text=f"抱歉，您不在用戶清單中，請將以下使用者編號提供給管理員：{line_id}"),
        )
        cursor.close()
        cnx.close()
        return

    user_line_id = event.source.user_id
    if user_line_id in admin_line_ids:
        if event.message.text == "用戶":
            query = "SELECT id, line_id, user_name FROM allowed_users ORDER BY id"
            cursor.execute(query)
            users = cursor.fetchall()

            users_text = "允許的用戶：\n"
            for user in users:
                users_text += f"{user[0]}. ({user[2]}) {user[1]}\n"

            line_bot_api.reply_message(
                event.reply_token,
                TextSendMessage(text=users_text),
            )
            cursor.close()
            cnx.close()
            return
        
        elif event.message.text.startswith("新增用戶 "):
            new_user_info = event.message.text.split(" ")[1:]
            new_user_line_id = new_user_info[0]
            new_user_name = new_user_info[1]

            query = "INSERT INTO allowed_users (line_id, user_name) VALUES (%s, %s)"
            cursor.execute(query, (new_user_line_id, new_user_name))
            cnx.commit()

            line_bot_api.reply_message(
                event.reply_token,
                TextSendMessage(text="用戶已新增。"),
            )
            cursor.close()
            cnx.close()
            return

        elif event.message.text.startswith("刪除用戶 "):
            user_id_to_delete = int(event.message.text.split(" ")[1])

            query = "SELECT id, line_id, user_name FROM allowed_users ORDER BY id"
            cursor.execute(query)
            users = cursor.fetchall()
            user_ids = [user[0] for user in users]
            if user_id_to_delete not in user_ids or user_id_to_delete < 1:
                line_bot_api.reply_message(
                    event.reply_token,
                    TextSendMessage(text="該用戶不存在。"),
                )
                cursor.close()
                cnx.close()
                return

            user_line_id = None
            for user in users:
                if user[0] == user_id_to_delete:
                    user_line_id = user[1]
                    break

            query = "DELETE FROM allowed_users WHERE line_id = %s"
            cursor.execute(query, (user_line_id,))
            cnx.commit()

            line_bot_api.reply_message(
                event.reply_token,
                TextSendMessage(text=f"用戶 {user_id_to_delete} 已刪除。"),
            )
            cursor.close()
            cnx.close()

        elif event.message.text == 'Help':
            flex_message = {
              "type": "carousel",
              "contents": [
                {
                  "type": "bubble",
                  "size": "nano",
                  "header": {
                    "type": "box",
                    "layout": "vertical",
                    "contents": [
                      {
                        "type": "text",
                        "text": "用戶列表",
                        "color": "#ffffff",
                        "align": "center",
                        "size": "lg",
                        "gravity": "center"
                      }
                    ],
                    "backgroundColor": "#27ACB2",
                    "paddingTop": "19px",
                    "paddingAll": "12px",
                    "paddingBottom": "16px"
                  },
                  "body": {
                    "type": "box",
                    "layout": "vertical",
                    "contents": [
                      {
                        "type": "box",
                        "layout": "horizontal",
                        "contents": [
                          {
                            "type": "text",
                            "text": "輸入'用戶'或點選查看當前用戶列表",
                            "color": "#8C8C8C",
                            "size": "sm",
                            "wrap": True,
                            "action": {
                              "type": "message",
                              "label": "action",
                              "text": "用戶"
                            }
                          }
                        ],
                        "flex": 1
                      }
                    ],
                    "spacing": "md",
                    "paddingAll": "12px"
                  },
                  "styles": {
                    "footer": {
                      "separator": False
                    }
                  }
                },
                {
                  "type": "bubble",
                  "size": "nano",
                  "header": {
                    "type": "box",
                    "layout": "vertical",
                    "contents": [
                      {
                        "type": "text",
                        "text": "新增用戶",
                        "color": "#ffffff",
                        "align": "center",
                        "size": "lg",
                        "gravity": "center"
                      }
                    ],
                    "backgroundColor": "#FF6B6E",
                    "paddingTop": "19px",
                    "paddingAll": "12px",
                    "paddingBottom": "16px"
                  },
                  "body": {
                    "type": "box",
                    "layout": "vertical",
                    "contents": [
                      {
                        "type": "box",
                        "layout": "horizontal",
                        "contents": [
                          {
                            "type": "text",
                            "text": "輸入：新增用戶+ user_id + user_name，來新增用戶",
                            "color": "#8C8C8C",
                            "size": "sm",
                            "wrap": True
                          }
                        ],
                        "flex": 1
                      }
                    ],
                    "spacing": "md",
                    "paddingAll": "12px"
                  },
                  "styles": {
                    "footer": {
                      "separator": False
                    }
                  }
                },
                {
                  "type": "bubble",
                  "size": "nano",
                  "header": {
                    "type": "box",
                    "layout": "vertical",
                    "contents": [
                      {
                        "type": "text",
                        "text": "刪除用戶",
                        "color": "#ffffff",
                        "align": "center",
                        "size": "lg",
                        "gravity": "center"
                      }
                    ],
                    "backgroundColor": "#A17DF5",
                    "paddingTop": "19px",
                    "paddingAll": "12px",
                    "paddingBottom": "16px"
                  },
                  "body": {
                    "type": "box",
                    "layout": "vertical",
                    "contents": [
                      {
                        "type": "box",
                        "layout": "horizontal",
                        "contents": [
                          {
                            "type": "text",
                            "text": "輸入：刪除用戶+ id，來刪除用戶",
                            "color": "#8C8C8C",
                            "size": "sm",
                            "wrap": True
                          }
                        ],
                        "flex": 1
                      }
                    ],
                    "spacing": "md",
                    "paddingAll": "12px"
                  },
                  "styles": {
                    "footer": {
                      "separator": False
                    }
                  }
                }
              ]
            }
            line_bot_api.reply_message(
                event.reply_token,
                FlexSendMessage(alt_text="Help Message", contents=flex_message)
            )

    if event.message.text == "頻道" and event.source.type == "group":
        group_id = event.source.group_id

        line_bot_api.reply_message(
            event.reply_token,
            TextSendMessage(text="群組ID: " + group_id),
        )
        
    elif event.message.text == "功能":
        # 建立美化過的 Flex Message
        flex_message = FlexSendMessage(
            alt_text="觸發型解剖事件錄影模組",
            contents={
              "type": "bubble",
              "hero": {
                "type": "image",
                "url": "https://lbcs.agri-twin.tw/00.share/TDEVE.png",
                "size": "full",
                "aspectRatio": "20:13",
                "aspectMode": "fit",
                "backgroundColor": "#E8E8E8"
              },
              "body": {
                "type": "box",
                "layout": "vertical",
                "spacing": "md",
                "contents": [
                  {
                    "type": "text",
                    "text": "觸發型解剖事件錄影模組",
                    "wrap": True,
                    "weight": "bold",
                    "gravity": "center",
                    "size": "xl"
                  },
                  {
                    "type": "box",
                    "layout": "vertical",
                    "margin": "lg",
                    "spacing": "sm",
                    "contents": [
                      {
                        "type": "box",
                        "layout": "baseline",
                        "spacing": "sm",
                        "contents": [
                          {
                            "type": "text",
                            "text": "使用說明：",
                            "color": "#aaaaaa",
                            "size": "sm",
                            "flex": 1
                          }
                        ]
                      },
                      {
                        "type": "box",
                        "layout": "baseline",
                        "spacing": "sm",
                        "contents": [
                          {
                            "type": "text",
                            "text": "請於解剖「開始」與「結束」時，分別按一次按鈕，系統將會自動裁切與保存「開始」至「結束」之時間段之影片。",
                            "wrap": True,
                            "color": "#666666",
                            "size": "sm",
                            "flex": 4
                          }
                        ]
                      }
                    ]
                  },
                  {
                    "type": "box",
                    "layout": "vertical",
                    "margin": "xxl",
                    "contents": [
                      {
                        "type": "text",
                        "text": "請至網頁平台觀看歷史影片",
                        "flex": 1,
                        "margin": "sm",
                        "color": "#aaaaaa",
                        "size": "sm",
                        "align": "center"
                      },
                      {
                        "type": "image",
                        "url": "https://lbcs.agri-twin.tw/00.share/TDEVE_QR-code_屏科.png",
                        "aspectMode": "cover",
                        "size": "xl",
                        "margin": "md",
                        "action": {
                          "type": "uri",
                          "label": "action",
                          "uri": "http://103.124.74.45/remotediagnosis/PHP-Login/login/index.php"
                        }
                      }
                    ]
                  }
                ]
              },
              "footer": {
                "type": "box",
                "layout": "vertical",
                "contents": [
                  {
                    "type": "text",
                    "text": "財團法人農業科技研究院，聯絡我們 : 037585765",
                    "color": "#aaaaaa",
                    "size": "xxs",
                    "wrap": True,
                    "offsetTop": "none",
                    "align": "center"
                  }
                ]
              }
            }
        )
        line_bot_api.reply_message(
            event.reply_token,
            flex_message,
        )

    cursor.close()
    cnx.close()
